<?php
session_start();
if (!isset($_SESSION["usuario"])) {
    header("Location: login.php");
    exit;
}

$archivo = __DIR__ . "/tareas.json";
$tareas = json_decode(file_get_contents($archivo), true) ?? [];

// Filtrar tareas según rol
if ($_SESSION["rol"] === "operario") {
    $tareas = array_filter($tareas, fn($t) => $t["persona"] === $_SESSION["usuario"]);
}
?>

<h2>Bienvenido <?= $_SESSION["usuario"] ?> (<?= $_SESSION["rol"] ?>)</h2>
<a href="logout.php">Cerrar sesión</a>
<hr>

<?php if ($_SESSION["rol"] === "admin"): ?>
<h3>Agregar nueva tarea</h3>
<form method="post" action="guardar_tarea.php">
    <label>Trabajador:</label>
    <input type="text" name="persona" required>
    <label>Rol:</label>
    <select name="rol" required>
        <option value="operario">Operario</option>
        <option value="admin">Admin</option>
    </select>
    <label>Tarea:</label>
    <input type="text" name="tarea" required>
    <label>Fecha y hora:</label>
    <input type="datetime-local" name="fecha" required>
    <button type="submit">Guardar tarea</button>
</form>
<hr>
<?php endif; ?>

<h3>Tareas</h3>
<form method="post" action="guardar_anotacion.php">
<table border="1" cellpadding="5">
    <tr>
        <th>Trabajador</th>
        <th>Rol</th>
        <th>Fecha / Hora</th>
        <th>Tarea</th>
        <th>Anotación</th>
        <?php if ($_SESSION["rol"] === "operario") echo "<th>Guardar</th>"; ?>
    </tr>
    <?php foreach ($tareas as $t): ?>
    <tr>
        <td><?= $t["persona"] ?></td>
        <td><?= $t["rol"] ?></td>
        <td><?= $t["fecha"] ?></td>
        <td><?= $t["tarea"] ?></td>
        <td>
            <input type="text" name="anotacion[<?= $t['id'] ?>]" value="<?= $t['anotacion'] ?? '' ?>" <?= $_SESSION["rol"] === "admin" ? 'readonly' : '' ?>>
        </td>
        <?php if ($_SESSION["rol"] === "operario"): ?>
            <td><button type="submit">Guardar</button></td>
        <?php endif; ?>
    </tr>
    <?php endforeach; ?>
</table>
</form>
