<?php
session_start();
if (!isset($_SESSION["usuario"])) {
    header("Location: login.php");
    exit;
}

if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST['anotacion'])) {
    $archivo = __DIR__ . "/tareas.json";
    $tareas = json_decode(file_get_contents($archivo), true) ?? [];

    foreach ($_POST['anotacion'] as $id => $nota) {
        foreach ($tareas as &$t) {
            if ($t['id'] == $id && $t['persona'] === $_SESSION["usuario"]) {
                $t['anotacion'] = htmlspecialchars($nota);
            }
        }
    }

    file_put_contents($archivo, json_encode($tareas, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
}

header("Location: dashboard.php");
exit;
