<?php
session_start();
if (!isset($_SESSION["usuario"]) || $_SESSION["rol"] !== "admin") {
    header("Location: login.php");
    exit;
}

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $archivo = __DIR__ . "/tareas.json";
    $tareas = json_decode(file_get_contents($archivo), true) ?? [];

    $nueva = [
        "id" => time() + rand(1,1000), // id único
        "persona" => htmlspecialchars($_POST["persona"]),
        "rol" => htmlspecialchars($_POST["rol"]),
        "tarea" => htmlspecialchars($_POST["tarea"]),
        "fecha" => $_POST["fecha"],
        "anotacion" => ""
    ];

    $tareas[] = $nueva;

    file_put_contents($archivo, json_encode($tareas, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
}

header("Location: dashboard.php");
exit;
