<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Validador DNI - Ilias</title>
    <link rel="stylesheet" href="style.css">
</head>
<body class="dark"> <main class="main-container">
        <div class="validator-card">
            <div class="card-header">
                <h1>Verificador de DNI</h1>
                <p>Introduce el número y la letra para validar</p>
            </div>

            <form method="POST" action="" class="dni-form">
                <div class="input-group">
                    <input type="text" name="dni" placeholder="00000000X" maxlength="9" required autocomplete="off">
                    <span class="focus-border"></span>
                </div>
                <button type="submit" name="validar" class="check-btn">Validar ahora</button>
            </form>

            <div class="result-container">
                <?php
                if (isset($_POST['validar'])) {
                    $dni = strtoupper(trim($_POST['dni']));
                    if (validarDNI($dni)) {
                        echo "<div class='result success'>
                                <span class='icon'>✅</span>
                                <div><strong>VÁLIDO</strong><br>Este DNI es auténtico</div>
                              </div>";
                    } else {
                        echo "<div class='result error'>
                                <span class='icon'>❌</span>
                                <div><strong>NO VÁLIDO</strong><br>La letra no coincide o el formato es erróneo</div>
                              </div>";
                    }
                }

                function validarDNI($dni) {
                    if (strlen($dni) !== 9) return false;
                    $letra = substr($dni, -1);
                    $numeros = substr($dni, 0, -1);
                    if (!is_numeric($numeros)) return false;
                    $letras_validas = "TRWAGMYFPDXBNJZSQVHLCKE";
                    $letra_correcta = $letras_validas[$numeros % 23];
                    return ($letra == $letra_correcta);
                }
                ?>
            </div>
        </div>
    </main>
</body>
</html>