<?php
include "conexion.php";

$resultado = $conn->query(
    "SELECT * FROM compralista ORDER BY tienda, nombre"
);
?>

<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Lista de la Compra</title>
    <link rel="stylesheet" href="style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
</head>

<body>

    <div class="app-container">

        <header>
            <h1>🛒 Lista de la Compra</h1>
        </header>

        <section class="form-section">
            <div class="form-item">
                <input type="text" id="nombre" placeholder="Producto">
                <button type="button" id="micBtn" title="Hablar">
                    <i class="fa-solid fa-microphone"></i>
                </button>
            </div>
            <div class="form-item">
                <select id="tienda">
                    <option value="Mercadona">Mercadona</option>
                    <option value="Lidl">Lidl</option>
                    <option value="DIA">DIA</option>
                    <option value="Carrefour">Carrefour</option>
                    <option value="Alcampo">Alcampo</option>
                </select>
            </div>
            <div class="form-item">
                <input type="number" id="precio" placeholder="Precio €" step="0.01">
            </div>
            <div class="form-item">
                <button onclick="agregar()">Agregar</button>
            </div>
        </section>

        <section class="lista">
            <?php
            $tiendaActual = "";
            while ($fila = $resultado->fetch_assoc()) {
                if ($tiendaActual != $fila['tienda']) {
                    $tiendaActual = $fila['tienda'];
                    echo "<h2 class='tienda'>$tiendaActual</h2>";
                }
                echo "
            <div class='item'>
                <span class='nombre'>{$fila['nombre']}</span>
                <span class='precio'>{$fila['precio']} €</span>
                <button class='btn-borrar' onclick='borrar({$fila['id']})'>
                    <i class='fa-solid fa-trash'></i>
                </button>
            </div>
            ";
            }
            ?>
        </section>

    </div>

    <script src="script.js"></script>
</body>

</html>