function agregar() {
    const nombre = document.getElementById("nombre").value.trim();
    const tienda = document.getElementById("tienda").value;
    const precio = document.getElementById("precio").value;

    if (nombre === "") {
        alert("Introduce un producto");
        return;
    }

    fetch("guardar.php", {
        method: "POST",
        headers: {
            "Content-Type": "application/x-www-form-urlencoded"
        },
        body: `nombre=${encodeURIComponent(nombre)}&tienda=${encodeURIComponent(tienda)}&precio=${precio}`
    }).then(() => location.reload());
}

function borrar(id) {
    if (!confirm("¿Eliminar este producto?")) return;

    fetch("borrar.php", {
        method: "POST",
        headers: {
            "Content-Type": "application/x-www-form-urlencoded"
        },
        body: `id=${id}`
    }).then(() => location.reload());
}
// =====================
// Reconocimiento de voz definitivo (último número → precio)
// =====================
const micBtn = document.getElementById("micBtn");
const inputNombre = document.getElementById("nombre");
const inputPrecio = document.getElementById("precio");

const SpeechRecognition =
  window.SpeechRecognition || window.webkitSpeechRecognition;

if (SpeechRecognition) {
    const recognition = new SpeechRecognition();
    recognition.lang = "es-ES";
    recognition.continuous = false;
    recognition.interimResults = false;

    micBtn.addEventListener("click", () => recognition.start());

    recognition.onstart = () => {
        micBtn.innerHTML = '<i class="fa-solid fa-microphone-lines"></i>';
    };

    recognition.onend = () => {
        micBtn.innerHTML = '<i class="fa-solid fa-microphone"></i>';
    };

    recognition.onresult = (event) => {
        const texto = event.results[0][0].transcript.trim();

        // Buscar todos los números en la frase
        const numeros = texto.match(/\d+[.,]?\d*/g);

        let precioValor = "";
        let nombreProducto = texto;

        if (numeros && numeros.length > 0) {
            // Tomamos el último número como precio
            precioValor = numeros[numeros.length - 1].replace(",", ".");

            // Eliminamos SOLO el último número del texto para dejar el producto limpio
            // (así los números iniciales se quedan en el nombre)
            const lastNumero = numeros[numeros.length - 1];
            // Regex que elimina solo la última ocurrencia
            const regex = new RegExp(lastNumero + "(?!.*" + lastNumero + ")");
            nombreProducto = texto.replace(regex, "").trim();
        }

        inputNombre.value = nombreProducto;
        inputPrecio.value = precioValor;

        // Si quieres agregar automáticamente, descomenta esta línea:
        // agregar();
    };

    recognition.onerror = (event) => {
        alert("Error de voz: " + event.error);
    };

} else {
    micBtn.disabled = true;
    micBtn.title = "Tu navegador no soporta reconocimiento de voz";
}