const API_KEY = 'f77ab25e87b58532727359552c99ad75'; 
const BASE_URL = 'https://api.themoviedb.org/3';
const IMG_PATH = 'https://image.tmdb.org/t/p/w500';

const contenedor = document.getElementById('contenedor-pelis');
const form = document.getElementById('form-busqueda');
const search = document.getElementById('search');
const modal = document.getElementById('modal-detalles');
const infoModal = document.getElementById('info-peli-modal');
const btnCerrar = document.querySelector('.cerrar');
const paginacionContenedor = document.getElementById('paginacion');

let paginaActual = 1;
let busquedaActual = '';

// Iniciar app
obtenerPeliculas(paginaActual);

async function obtenerPeliculas(page, query = '') {
    let url = query 
        ? `${BASE_URL}/search/movie?api_key=${API_KEY}&language=es-ES&query=${query}&page=${page}`
        : `${BASE_URL}/discover/movie?sort_by=popularity.desc&api_key=${API_KEY}&language=es-ES&page=${page}`;

    const res = await fetch(url);
    const data = await res.json();
    
    mostrarPeliculas(data.results);
    renderPaginacion(data.total_pages);
}

function mostrarPeliculas(peliculas) {
    contenedor.innerHTML = '';
    peliculas.forEach(peli => {
        const { title, poster_path, vote_average } = peli;
        if(!poster_path) return;

        const div = document.createElement('div');
        div.classList.add('pelicula');
        div.innerHTML = `
            <img src="${IMG_PATH + poster_path}" alt="${title}">
            <div class="info">
                <h3>${title}</h3>
                <span>⭐ ${vote_average.toFixed(1)}</span>
            </div>
        `;
        // Pasamos todo el objeto peli para asegurar que la descripción llegue
        div.onclick = () => abrirDetalles(peli);
        contenedor.appendChild(div);
    });
}

function renderPaginacion(total) {
    paginacionContenedor.innerHTML = '';
    const limitePaginas = Math.min(total, 500); // TMDB limita a 500
    
    let inicio = Math.max(1, paginaActual - 2);
    let fin = Math.min(limitePaginas, inicio + 4);

    for(let i = inicio; i <= fin; i++) {
        const btn = document.createElement('button');
        btn.innerText = i;
        if(i === paginaActual) btn.classList.add('active');
        btn.onclick = () => {
            paginaActual = i;
            obtenerPeliculas(paginaActual, busquedaActual);
            window.scrollTo({top: 0, behavior: 'smooth'});
        };
        paginacionContenedor.appendChild(btn);
    }
}

// Buscador (Tu lógica original)
form.addEventListener('submit', (e) => {
    e.preventDefault();
    const b = search.value;
    if(b && b !== '') {
        busquedaActual = b;
        paginaActual = 1;
        obtenerPeliculas(paginaActual, busquedaActual);
        search.value = '';
    } else {
        window.location.reload();
    }
});

async function abrirDetalles(peli) {
    // Buscamos el tráiler
    const res = await fetch(`${BASE_URL}/movie/${peli.id}/videos?api_key=${API_KEY}&language=es-ES`);
    const data = await res.json();
    const trailer = data.results.find(v => v.type === 'Trailer' && v.site === 'YouTube');

    // ARREGLO DE DESCRIPCIÓN: Validamos que existan los datos
    const descripcion = peli.overview ? peli.overview : "No hay descripción disponible para esta película.";
    const fecha = peli.release_date ? peli.release_date : "Desconocida";

    infoModal.innerHTML = `
        <div class="detalles-flex">
            <img src="${IMG_PATH + peli.poster_path}" alt="${peli.title}">
            <div>
                <h2 style="margin-top:0">${peli.title}</h2>
                <p><strong>Fecha de estreno:</strong> ${fecha}</p>
                <p><strong>Valoración:</strong> ⭐ ${peli.vote_average}</p>
                <p><strong>Sinopsis:</strong></p>
                <p style="line-height: 1.6; color: #ccc;">${descripcion}</p>
            </div>
        </div>
        ${trailer ? `
            <div class="video-container">
                <iframe src="https://www.youtube.com/embed/${trailer.key}" allowfullscreen></iframe>
            </div>
        ` : '<p style="margin-top:20px; text-align:center; color: #666;">Tráiler no disponible.</p>'}
    `;
    
    modal.style.display = "block";
    document.body.style.overflow = "hidden";
}

const cerrarM = () => {
    modal.style.display = "none";
    infoModal.innerHTML = ''; 
    document.body.style.overflow = "auto";
};

btnCerrar.onclick = cerrarM;
window.onclick = (e) => { if(e.target == modal) cerrarM(); };