<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Actualidad Informativa</title>

    <link rel="stylesheet" href="https://code.jquery.com/ui/1.14.2/themes/base/jquery-ui.css">

    <script src="https://code.jquery.com/jquery-3.7.1.js"></script>
    <script src="https://code.jquery.com/ui/1.14.2/jquery-ui.js"></script>

    <script>
        function verNoticia(idNoticia) {
            $.get("includes/noticia.php?key=" + idNoticia, function (contenido) {
                $("#dialog-message").html(contenido);
            });

            $("#dialog-message").dialog({
                modal: true,
                width: $(window).width() * 0.95,
                height: $(window).height() * 0.8,
                buttons: {
                    Cerrar: function () {
                        $(this).dialog("close");
                    }
                }
            });
        }
    </script>

    <link rel="stylesheet" href="style.css">
</head>

<body>

    <main>
        <h1>Noticias de Hoy</h1>

        <?php
        include_once('includes/datos.php');

        $resultado = $mysqli->query("SELECT * FROM noticias");

        echo "<ul class='listados'>";

        while ($fila = $resultado->fetch_assoc()) {

            $rutaImagen = "imagenes/{$fila['id']}.jpg";
            $hayImagen = file_exists($rutaImagen);

            if ($hayImagen) {
                echo "
                <li class='confoto'>
                    <div>
                        <img src='$rutaImagen' alt='Imagen relacionada con la noticia'>
                    </div>
                    <div onclick='verNoticia({$fila['id']})'>
                        <h2>{$fila['titulo']}</h2>
                        <p>{$fila['texto']}</p>
                    </div>
                </li>";
            } else {
                echo "
                <li class='sinfoto'>
                    <div onclick='verNoticia({$fila['id']})'>
                        <h2>{$fila['titulo']}</h2>
                        <p>{$fila['texto']}</p>
                    </div>
                </li>";
            }
        }

        echo "</ul>";
        ?>

        <div id="dialog-message" title="Detalle de la noticia"></div>
    </main>

</body>

</html>